% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.valid_app.R
\name{is.valid_app}
\alias{is.valid_app}
\alias{is.valid_token}
\title{Determine whether or not a given application token is valid}
\usage{
is.valid_app(token)

is.valid_token(token)
}
\arguments{
\item{token}{A application token (e.g., "azGDORePK8gMaC0QOYAMyEEuzJnyUi")}
}
\value{
A logical value indicating whether the application token is valid
(\code{TRUE}) or not (\code{FALSE})
}
\description{
\code{is.valid_app} determines whether or not a given application token
is valid or not according to Pushover's specifications. It does not determine
whether or not the given token is associated with an application.

\code{is.valid_token} is deprecated in favor of \code{is.valid_app}
}
\note{
To acquire an application token, create an app at
\url{https://pushover.net/apps}
}
\examples{
is.valid_app(token = "azGDORePK8gMaC0QOYAMyEEuzJnyUi")

}

