% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-auto-browse.R
\name{auto_browse}
\alias{auto_browse}
\title{Wrap a function so it will automatically \code{browse()} on error}
\usage{
auto_browse(.f)
}
\arguments{
\item{.f}{A function to modify, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. Only recommended if you require backward
compatibility with olders version of R.
}}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
A function wrapped with \code{auto_browse()} will automatically enter an
interactive debugger using \code{\link[=browser]{browser()}} when ever it encounters an error.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
# For interactive usage, auto_browse() is useful because it automatically
# starts a browser() in the right place.
f <- function(x) {
  y <- 20
  if (x > 5) {
    stop("!")
  } else {
    x
  }
}
if (interactive()) {
  map(1:6, auto_browse(f))
}

}
\seealso{
Other adverbs: 
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{quietly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
