% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rerun.R
\name{rerun}
\alias{rerun}
\title{Re-run expressions multiple times.}
\usage{
rerun(.n, ...)
}
\arguments{
\item{.n}{Number of times to run expressions}

\item{...}{Expressions to re-run.}
}
\value{
A list of length \code{.n}. Each element of \code{...} will be
  re-run once for each \code{.n}. It

  There is one special case: if there's a single unnamed input, the second
  level list will be dropped. In this case, \code{rerun(n, x)} behaves like
  \code{replicate(n, x, simplify = FALSE)}.
}
\description{
This is a convenient way of generating sample data. It works similarly to
\code{\link{replicate}(..., simplify = FALSE)}.
}
\examples{
10 \%>\% rerun(rnorm(5))
10 \%>\%
  rerun(x = rnorm(5), y = rnorm(5)) \%>\%
  map_dbl(~ cor(.x$x, .x$y))
}

