% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map.R
\name{map}
\alias{map}
\alias{map_chr}
\alias{map_dbl}
\alias{map_int}
\alias{map_lgl}
\alias{walk}
\title{Apply a function to each element of a list.}
\usage{
map(.x, .f, ...)

map_lgl(.x, .p, ...)

map_chr(.x, .f, ...)

map_int(.x, .f, ...)

map_dbl(.x, .f, ...)

walk(.x, .f, ...)
}
\arguments{
\item{.x}{A list or vector.}

\item{.f}{A function, formula or string.

  If a function, it is used as is.

  If a formula, e.g. \code{~ .x + 2}, it is converted to a function with
  a three arguments, \code{.x} or \code{.}, \code{.y}, \code{.z}. This allows
  you to create very compact anonymous functions of up to 3 variables.

  If a string, e.g. \code{"y"}, it is converted to an extractor function,
  \code{function(x) x[["y"]]}.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.p}{A predicate: either a function, in any of the ways possible
for \code{.f}, or a logical vector the same length as \code{.x}.}
}
\value{
\code{map()} a list if \code{.x} is a list or a data frame
  if \code{.x} is a data frame.

  \code{map_lgl()} returns a logical vector, \code{map_int()} an integer
  vector, \code{map_dbl()}, a numeric vector, \code{map_chr()}, a character
  vector.

  \code{walk()} (invisibly) the input \code{.x}. It's called primarily for
  its side effects, but this makes it easier to combine in a pipe.
}
\description{
\code{map()} returns the transformed input; \code{walk()} calls
\code{.f} for its side-effect and returns the original
input. \code{map()} returns a list or a data frame; \code{map_lgl()},
\code{map_int()}, \code{map_dbl()} and \code{map_chr()} return vectors
of the corresponding type (or die trying).
}
\examples{
1:10 \%>\%
  map(rnorm, n = 10) \%>\%
  map(mean, .type = numeric(1))

# Or use an anonymous function
1:10 \%>\%
  map(function(x) rnorm(10, x))

# Or a formula
1:10 \%>\%
  map(~ rnorm(10, .x))

# A more realistic example: split a data frame into pieces, fit a
# model to each piece, summarise and extract R^2
mtcars \%>\%
  split(.$cyl) \%>\%
  map(~ lm(mpg ~ wt, data = .x)) \%>\%
  map(summary) \%>\%
  map_dbl("r.squared")

# Use map_lgl(), map_dbl(), etc to reduce to a vector.
# * list
mtcars \%>\% map(sum)
# * vector
mtcars \%>\% map_dbl(sum)
}
\seealso{
\code{\link{map2}()} and \code{\link{map3}()} to map over multiple
  inputs simulatenously
}

