% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rows.R
\name{by_row}
\alias{by_row}
\alias{map_rows}
\title{Apply a function to each row of a data frame}
\usage{
by_row(.d, ..f, ..., .labels = TRUE)

map_rows(.d, .f, ..., .labels = TRUE)
}
\arguments{
\item{.d}{A sliced data frame.}

\item{...}{Further arguments passed to \code{..f}.}

\item{.labels}{If \code{TRUE}, the returned data frame is prepended
with the labels of the slices (the columns in \code{.d} used to
define the slices). They are recycled to match the output size in
each slice if necessary.}

\item{.f,..f}{A function to apply to each row. If \code{..f} does
not return a data frame or an atomic vector, a list-column is
created under the name \code{.out}. If it returns a data frame, it
should have the same number of rows within groups and the same
number of columns between groups.}
}
\value{
A data frame.
}
\description{
Applies \code{..f} to each row of \code{.d}. By default, the whole
row is appended to the result to serve as identifier (set
\code{.labels} to \code{FALSE} to prevent this). In addition, if
\code{..f} returns a multi-rows data frame or a non-scalar atomic
vector, a \code{.row} column is appended to identify the row number
in the original data frame. If \code{..f}'s output is not a data
frame nor an atomic vector, a list-column is created. In all cases,
\code{by_row()} and \code{map_row()} create a data frame in tidy
format.
}
\details{
\code{map_rows()} is intended to provide a version of
\code{map_n()} that works better with data frames. The distinction
between \code{by_row()} and \code{map_rows()} is that the former
passes a data frame to \code{..f} while the latter maps the columns
to its function call. This is essentially like using
\code{\link{map_call}()} with each row of a data frame. Another way
to view this is that \code{map_row()} is equivalent to using
\code{by_row()} with a function lifted to accept dots (see
\code{\link{lift_ld}()}).
}
\examples{
# ..f should be able to work with a list or a data frame. As it
# happens, sum() handles data frame so the following works:
mtcars \%>\% by_row(sum)

# Other functions such as mean() may need to be adjusted with one
# of the lift_xy() helpers:
mtcars \%>\% by_row(lift_vl(mean))

# To run a function with map_rows(), make sure it is variadic (that
# it accepts dots)
mtcars \%>\% map_rows(sum)
mtcars \%>\% map_rows(lift_vd(mean))
}
\seealso{
\code{\link{by_slice}()}
}

