% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{odds_trend}
\alias{odds_trend}
\title{Function to calculate OR using Wald CI, and plot trend.}
\usage{
odds_trend(formula, data, ...)
}
\arguments{
\item{formula}{A formula of the form outcome ~ exposure.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{...}{Passes optional arguments to \link{oddsratio}.}
}
\value{
Displays odds ratio, analysis of trend and plot.
}
\description{
\code{odds_trend} calculates the odds ratio with confidence intervals (Wald) for different levels
(three or more) of the exposure variable, constructs the corresponding plot and calculates if the trend is
significant or not.
}
\details{
\code{odds_trend} is a wrap function that calls \link{oddsratio} from package \code{epitools}.
}
\examples{
## A cross-sectional study looked at the association between obesity and a biopsy resulting
## from mammography screening.

Freq <- c(3441, 34, 39137, 519, 20509, 280, 12149, 196, 11882, 199)
Biopsy <- gl(2, 1, 10, labels = c("No", "Yes"))
Weight <- gl(5, 2, 10, labels = c("Underweight", "Normal", "Over (11-24\%)",
             "Over (25-39\%)", "Over (> 39\%)"))
breast <- data.frame(Freq, Biopsy, Weight)
breast

breast <- expand_df(breast)
odds_trend(Biopsy ~ Weight, data = breast)
}
\seealso{
\link{oddsratio}
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Tomas Aragon, University of Berkeley, USA.
}
