% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlets.R
\name{outlets_nearby}
\alias{outlets_nearby}
\title{Information for outlets near a given location}
\usage{
outlets_nearby(
  latitude,
  longitude,
  max_distance = NULL,
  max_results = 30,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{latitude}{Numeric. Latitude in decimal degrees. For example, Flinders
Street Station is at approximately -37.8183 latitude.}

\item{longitude}{Numeric. Longitude in decimal degrees. For example, Flinders
Street Station is at approximately 144.9671 longitude.}

\item{max_distance}{Integer. Optionally filter by maximum distance from the
given location, in metres.}

\item{max_results}{Integer. Defaults to 30. Caps the number of results
returned.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item {\code{outlet_slid_spid}}
\item {\code{outlet_name}}
\item {\code{outlet_business}}
\item {\code{outlet_latitude}}
\item {\code{outlet_longitude}}
\item {\code{outlet_suburb}}
\item {\code{outlet_postcode}}
\item {\code{outlet_business_hour_mon}}
\item {\code{outlet_business_hour_tue}}
\item {\code{outlet_business_hour_wed}}
\item {\code{outlet_business_hour_thu}}
\item {\code{outlet_business_hour_fri}}
\item {\code{outlet_business_hour_sat}}
\item {\code{outlet_business_hour_sun}}
\item {\code{outlet_notes}}
}
}
\description{
Information for outlets near a given location
}
\details{
The \code{outlet_name} reported here is more accurately described as an outlet
\emph{address}. We keep the \code{outlet_name} column name as this is how the PTV API
describes it.

The business hours are reported as characters. Usually they take on
a format of "8.00AM - 10.00PM", but there variants such as "7.30AM - 11.00AM
and 1.30PM - 6.00PM". For days on which an outlet is closed, the opening
hours are usually reported as "CLOSED", but can also be an empty character.
Some opening hours are "24 Hours". These fields are also filled with missing
values and empty characters.
}
\examples{
\dontrun{
outlets_nearby(latitude = -37.8183, longitude = 144.9671)
}

}
