% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmf.R
\name{pmf}
\alias{pmf}
\title{Probability mass function plot for a discrete variable}
\usage{
pmf(x, absolute = T, xlim = NULL, lwd = 1, col = "black",
  title = NULL, xlab = NULL, bty = "l", cex.title = NULL,
  cex.axis = NULL)
}
\arguments{
\item{x}{the (discrete) variable of interest}

\item{absolute}{logical. If \code{TRUE} (default) absolute frequencies 
are plotted, if \code{FALSE} relative frequencies}

\item{xlim}{limits for the x axis}

\item{lwd}{line width}

\item{col}{color used for the vertical frequency bars}

\item{title}{plot title}

\item{xlab}{label for the x axis}

\item{bty}{box type (default is \code{bty="l"})}

\item{cex.title}{title font size}

\item{cex.axis}{font size for the axes}
}
\description{
This function produces a simple plot of the probability mass function
of a discrete variable
}
\examples{
pmf(cars$speed)
pmf(cars$speed, absolute = FALSE)
pmf(cars$speed, lwd = 2, col = 'blue')
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (2020). Poisson-Tweedie 
mixed-effects model: a flexible approach for the analysis of longitudinal RNA-seq
data. Statistical Modelling. URL: https://doi.org/10.1177/1471082X20936017
}
\author{
Mirko Signorelli
}
