% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-utils.R
\name{densityplot}
\alias{densityplot}
\title{A density plot}
\usage{
densityplot(
  x,
  data,
  by = NULL,
  position = "stack",
  facet = NULL,
  facet_type = "wrap",
  alpha = 1,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{x}{The numeric variable that is to be density plotted.}

\item{data}{A data frame with at least one numeric variable (the \code{x}
variable).}

\item{by}{A categorical variable by which to group the \code{x} values. If
provided there will be one density plot for each set of \code{x} values grouped by
the values of the \code{by} variable.}

\item{position}{If the \code{by} variable is provided, there are three ways these
multiple density plots can be positioned: stacked (\code{position = 'stack'}),
superimposed (\verb{position = identity'}).}

\item{facet}{A character string or character vector. If provided, we
\code{facet_wrap} (by default) the histogram by the variables. This is
equivalent to the \code{facet_wrap(variables)} in \code{ggplot2}.}

\item{facet_type}{By default, this takes the value of \code{wrap}, and \code{facet}
leads to a facet wrap. If \code{facet_type} is \code{grid}, then \code{facet} gives us a
\code{facet_grid}.}

\item{alpha}{The transparency to for the filled histogram bars. This is
probably only required when using \code{position = 'identity'}.}

\item{xlab}{The label of the x-axis (defaults to the \code{x} variable name).}

\item{ylab}{The label of the y-axis (defaults to the \code{y} variable name).}
}
\value{
A \code{ggplot2::ggplot} object, which may be modified with further \code{ggplot2}
commands.
}
\description{
This is a wrapper to the typical \code{ggplot} based density plot, i.e., using
\code{geom_density}. A continuous variable, \code{x}, is required as an input.
Optionally, a \code{by} categorical variable can be provided.
}
\examples{
densityplot(x = age, data = schizophrenia, by = gender)
}
