% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetHumRatioFromVapPres}
\alias{GetHumRatioFromVapPres}
\title{Return humidity ratio given water vapor pressure and atmospheric pressure.}
\usage{
GetHumRatioFromVapPres(VapPres, Pressure)
}
\arguments{
\item{VapPres}{A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]
}
\description{
Return humidity ratio given water vapor pressure and atmospheric pressure.
}
\examples{
SetUnitSystem("IP")
GetHumRatioFromVapPres(seq(0.4, 0.6, 0.01), 14.175)

SetUnitSystem("SI")
GetHumRatioFromVapPres(seq(3000, 4000, 100), 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 20
}
