% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess.R
\name{assess}
\alias{assess}
\title{Compare a patient's score to a control group}
\usage{
assess(patient, mean = 0, sd = 1, n = NULL, controls = NULL, CI = 95,
  treshold = 0.05, iter = 10000, color_controls = "#2196F3",
  color_CI = "#E91E63", color_score = "black", color_size = 2,
  alpha_controls = 1, alpha_CI = 0.8, verbose = TRUE)
}
\arguments{
\item{patient}{Single value (patient's score).}

\item{mean}{Mean of the control sample.}

\item{sd}{SD of the control sample.}

\item{n}{Size of the control sample.}

\item{controls}{Vector of values (control's scores).}

\item{CI}{Credible interval bounds.}

\item{treshold}{Significance treshold.}

\item{iter}{Number of iterations.}

\item{color_controls}{Color of the controls distribution.}

\item{color_CI}{Color of CI distribution.}

\item{color_score}{Color of the line representing the patient's score.}

\item{color_size}{Size of the line representing the patient's score.}

\item{alpha_controls}{Alpha of the CI distribution.}

\item{alpha_CI}{lpha of the controls distribution.}

\item{verbose}{Print possible warnings.}
}
\value{
output
}
\description{
Compare a patient's score to a control group.
}
\details{
Until relatively recently the standard way of testing for a difference between a case and controls was to convert the case’s score to a z score using the control sample mean and standard deviation (SD). If z was less than -1.645 (i.e., below 95% of the controls) then it was concluded that the case was significantly lower than controls. However, this method has serious disadvantages (Crawford and Garthwaite, 2012).
}
\examples{
result <- assess(patient=124, mean=100, sd=15, n=100)
print(result)
plot(result)

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
