% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r_internal.R
\name{.lambda_bvirr}
\alias{.lambda_bvirr}
\title{Internal function to produce lambda coefficients to use in the Case V correction for bivariate indirect range restriction.}
\usage{
.lambda_bvirr(ux, uy, sign_rxz = 1, sign_ryz = 1)
}
\arguments{
\item{ux}{Vector of observed-score u ratios for X.}

\item{uy}{Vector of observed-score u ratios for Y.}

\item{sign_rxz}{Sign of the relationship between X and the selection mechanism.}

\item{sign_ryz}{Sign of the relationship between Y and the selection mechanism.}
}
\value{
A vector of lambda values.
}
\description{
Internal function to produce lambda coefficients to use in the Case V correction for bivariate indirect range restriction.
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2019). Not restricted to selection research:
Accounting for indirect range restriction in organizational research.
\emph{Organizational Research Methods}. Advance online publication.
\url{https://doi.org/10.1177/1094428119859398}
}
\keyword{internal}
