% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovDispMeans.R
\name{aovDispMeans}
\alias{aovDispMeans}
\title{aovDispMeans}
\usage{
aovDispMeans(ezObj, value = "value", name = sys.call())
}
\arguments{
\item{ezObj}{Output from ezANOVA  (NB. ezANOVA must be called with \"return_aov = TRUE\"")}

\item{value}{String for column name}

\item{name}{Required for heading}
}
\description{
Displays marginal means from model.tables in the command window.
}
\examples{
library(psychReport)
requiredPackages(c("ez"))
# Example 1:
# create dataframe
dat <- createDF(nVP = 50,
                nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list(list(c("Comp:comp"), vals = c(500, 100, 100)),
                                list(c("Comp:incomp"), vals = c(520, 100, 100))))

aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
aovDispMeans(aovRT)

}
