% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STEN.R
\name{STEN}
\alias{STEN}
\title{Standard Ten (STEN) Scores for a set of athlete measurements}
\usage{
STEN(subject, trial, ...)
}
\arguments{
\item{subject}{The vector of athletes who recorded the results for each metric (can be a numeric or factor variable)}

\item{trial}{The vector that represents which trial each measurement came from}

\item{...}{Numeric vectors that represent the metrics which scores should be computed to STEN scores. These vectors hold the
scores that each athlete recorded for each respective metric (at least one metric must be passed to the function).}
}
\value{
A data frame, with the subjects as rows and the metrics as columns, and each entry representing the original measurement
  of the given metric having been converted to the unit-less STEN score.
}
\description{
Converts each score of each metric passed to the function into its corresponding STEN score. The STEN score converts
  metrics that have different units to the same scale, with a minimum value of 1 and a maximum value of 10 for all metrics. This
  allows one to easily compare an athlete's scores for different metrics that are measured in different units, which enables one
  to identify which metrics are areas of strength and which are areas of weakness for each athlete. The STEN method fulfills the
  same purpose as standardizing the scores (i.e. converting all of the scores to z-scores), but might be easier for practitioners
  and coaches to understand.
}
\examples{
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
STEN(subject, trial, metric_1, metric_2, metric_3)

}
\references{
Glen, S. (2015). Stephanie Glen. "STEN Score" From StatisticsHowTo.com: Elementary Statistics for the rest of us!
  https://www.statisticshowto.com/sten-score/
}
