test_that("sim_estimate_effect_variance works", {
  draws <- structure(
    c(
      -412.83, -414.276, -412.848, -414.638, -413.927,
      -415.534, -413.869, -413.196, -413.798, -413.219, -414.75, -413.407,
      -413.165, -413.701, -412.857, -414.654, -416.023, -414.088, -413.618,
      -416.707, -415.452, -415.335, -414.852, -414.325, -414.283, -415.23,
      -416.44, -414.284, -413.816, -413.041, -414.579, -413.695, -416.314,
      -415.437, -414.23, -413.451, -413.193, -413.387, -414.074, -413.34,
      0.250335, 0.551131, 0.268917, 0.179749, 0.0744763, -0.123686,
      0.503971, 0.203097, 0.0491559, 0.396705, 0.166251, 0.475368,
      0.413616, 0.51677, 0.229661, -0.0467696, -0.141839, 0.541037,
      0.321426, -0.167233, 0.00862374, -0.0228896, 0.0989856, -0.0167945,
      0.211767, 0.317657, -0.0365623, 0.367182, 0.359325, 0.201804,
      0.601612, 0.508384, 0.57635, 0.579637, 0.579724, 0.342413, 0.436827,
      0.433957, 0.516132, 0.435426, 0.0605164, -0.091321, 0.0879507,
      0.243632, 0.0549889, 0.189213, 0.0496397, 0.0243327, 0.101779,
      0.0758746, -0.0533409, 0.00427315, -0.0161742, -0.028293, 0.0865767,
      0.141244, 0.258186, 0.0298802, -0.0555206, 0.12303, 0.288492,
      0.276657, 0.262485, 0.136072, 0.220711, -0.131059, 0.00421781,
      0.168799, 0.146771, 0.0452336, 0.000421341, 0.0177618, -0.20432,
      -0.163975, -0.0294059, -0.0484251, 0.0190045, -0.0426243, -0.0880754,
      0.0570372, 1.28446, 1.73521, 1.30855, 1.19692, 1.07732, 0.883657,
      1.65528, 1.22519, 1.05038, 1.48692, 1.18087, 1.60861, 1.51228,
      1.6766, 1.25817, 0.954307, 0.867761, 1.71779, 1.37909, 0.846002,
      1.00866, 0.97737, 1.10405, 0.983346, 1.23586, 1.3739, 0.964098,
      1.44366, 1.43236, 1.22361, 1.82506, 1.6626, 1.77953, 1.78539,
      1.78555, 1.40834, 1.54779, 1.54335, 1.67553, 1.54562
    ),
    dim = c(10L, 4L, 4L),
    dimnames = list(
      iteration = c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"),
      chain = c("1", "2", "3", "4"),
      variable = c("lp__", "beta_trt", "alpha", "OR_trt")
    ),
    class = c("draws_array", "draws", "array")
  )
  result <- sim_estimate_effect_variance(draws)
  expect_equal(result, var(draws[, , "beta_trt"]))
})
