% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu_time.R
\name{simu_time}
\alias{simu_time}
\title{Simulate time-to-events for multiple scenarios}
\usage{
simu_time(dt, eventObj, clinInt, clinExt, seed, path)
}
\arguments{
\item{dt}{a list of \code{matrix} generated in \code{\link{simu_cov}} containing simulated covariates information}

\item{eventObj}{an object of class \code{.eventClass} generated in \code{\link{set_event}} including event information}

\item{clinInt}{an object of class \code{.clinClass} generated in \code{\link{set_clin}} including internal trial information}

\item{clinExt}{an object of class \code{.clinClass} generated in \code{\link{set_clin}} including external trial information}

\item{seed}{the seed of R‘s random number generator. Default is the first element of .Random.seed}

\item{path}{file name for saving the output including folder path}
}
\value{
a list of \code{matrix} containing simulated time-to-events information
}
\description{
Simulate time-to-events for multiple scenarios
}
\examples{
# simulate patient-level data without covariates
# simulate survival time following weibull distribution

# simulate trial indicator and set hazard ratios
sample = set_n(ssC = 10, ssE = 20, ssExt = 40)
sample_hr <- simu_cov(ssObj = sample, HR = 1, driftHR=c(1,1.2), nsim = 10)

# enrollment pattern, drop-out, analysis start time
c_int = set_clin(gamma = 2, e_itv = 10, etaC = 0.5,  CCOD = "fixed-first", CCOD_t = 64)
c_ext = c_int

# simulate time-to-event with a weibull distribution
evt1 <- set_event(event = "weibull", shape = 0.8, lambdaC = 0.01)
simu_time(dt = sample_hr, eventObj = evt1, clinInt = c_int, clinExt = c_ext)

# simulate time-to-event with an exponential distribution
evt2 <- set_event(event = "pwexp", t_itv = 1, lambdaC = c(0.1, 0.02))
simu_time(dt = sample_hr, eventObj = evt2, clinInt = c_int, clinExt = c_int)


}
\keyword{simulator}
