% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harmonization_function.R
\name{harmonization}
\alias{harmonization}
\title{Harmonization Function}
\usage{
harmonization(
  harmonization_sheet,
  long_dataset = TRUE,
  wide_dataset = TRUE,
  error_log = TRUE,
  source_variables = TRUE,
  na_string = "NA",
  verbose = TRUE
)
}
\arguments{
\item{harmonization_sheet}{Harmonization sheet input. Set of coding
instructions}

\item{long_dataset}{(TRUE/FALSE) Should the function return a long dataset?}

\item{wide_dataset}{(TRUE/FALSE) Should the function return a wide dataset?}

\item{error_log}{(TRUE/FALSE) Should the function return an error log?}

\item{source_variables}{(TRUE/FALSE) Should the output datasets contain the original non
modified values?}

\item{na_string}{Character string of final recode value to be set to missing.
Default is 'NA'. For example, if you use \code{code_type} of 'recode', and some of
your final values are 'NA', they will be set to missing.}

\item{verbose}{(TRUE/FALSE) Should the \code{harmonization()} function print
the current progress to the console?}
}
\value{
List of return objects with S3 class of 'psHarmonize'. Can be used
as input for report function \code{\link[=create_summary_report]{create_summary_report()}} and
\code{\link[=create_error_log_report]{create_error_log_report()}}.
}
\description{
This is the main function in the psHarmonize package. Takes a harmonization
sheet as input, and returns a harmonization object (list with S3 class of
'psHarmonize'). Requires source data.frames to be in the global environment.
}
\details{
\strong{Note:} psHarmonize evaluates and runs code entered in the harmonization sheet.
Make sure to only use harmonization sheets from authors you trust.
}
\examples{

# Running harmonization function with example harmonization sheet
harmonization_obj <- harmonization(harmonization_sheet = harmonization_sheet_example)

# Extracting harmonized long dataset (each row is a visit)
long_dataset <- harmonization_obj$long_dataset

# Extracting harmonized wide dataset (each row is a person)
# Visits are expressed in multiple columns
wide_dataset <- harmonization_obj$wide_dataset


}
