
## test C interfaces

library(proxy)

set.seed(20070630)

x <- as.dist(matrix(runif(25),5,5))
x
attributes(x)

z <- .Call(proxy:::R_subset_dist, x, 3)
z

unclass(z)

.Call(proxy:::R_subset_dist, x, c(1,3,5))

attr(x, "Labels") <- LETTERS[1:5]

z <- .Call(proxy:::R_subset_dist, x, c("A","C","E"))
z
attributes(z)

attr(x, "Labels") <- NULL

.Call(proxy:::R_rowSums_dist, x, FALSE)
.Call(proxy:::R_rowSums_dist, z, FALSE)

.Call(proxy:::R_row_dist, x, FALSE)       # row()
.Call(proxy:::R_row_dist, x, TRUE)        # col()

## test R interfaces

dim(x)
dimnames(x) <- letters[1:5]
dimnames(x)

row.dist(x)
col.dist(x)

subset(x, c(1,3,5))
x[[c(1,3,5)]]
x[c(1,3,5)]                         # as usual

x[1:2,2:3]
x[1,]
x[,2]

x[[-1]]                             # drop subscripts

x[[1]]                              # empty

###
