% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{ternaryplot}
\alias{ternaryplot}
\title{Plot a ternary diagram}
\usage{
ternaryplot(x, y, z, type = "empty", pch = NA, labels = names(x), ...)
}
\arguments{
\item{x}{vector with the first variable}

\item{y}{vector with the second variable}

\item{z}{vector with the third variable}

\item{type}{adds annotations to the ternary diagram, one of either
\code{empty}, \code{QFL}, \code{QFL.dickinson} or
\code{QmFLt.dickinson}}

\item{pch}{plot symbol}

\item{labels}{vector of strings to be added to the plot symbols}

\item{...}{optional arguments to the generic \code{points} function}
}
\description{
Plots triplets of compositional data on a ternary diagram
}
\examples{
PT <- read.HMdata(system.file("PT.csv",package="provenance"))
q <- PT$x[,'Q']
f <- PT$x[,'KF'] + PT$x[,'P']
l <- PT$x[,'Lm'] + PT$x[,'Lv'] + PT$x[,'Ls']
ternaryplot(q,f,l,type='QFL.dickinson',labels=names(PT))
}

