/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.Cancellable;
import com.qarks.util.CancellableImpl;
import com.qarks.util.files.diff.Diff;
import com.qarks.util.files.diff.FileDiffResult;
import com.qarks.util.files.diff.ui.DiffPanel;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class FileDiffMonitorDialog
extends JDialog
implements ActionListener {
    private FileDiffResult result = null;
    private DiffThread diffThread;
    private Frame parentFrame;
    private JButton cancel;
    private Timer timer;
    private DiffPanel editor;

    public FileDiffMonitorDialog(Window window, String string, String string2, boolean bl, DiffPanel diffPanel) {
        super(window, ResourceManager.getString((Object)ResourceKeyDiff.DIFF_MONITOR), Dialog.ModalityType.APPLICATION_MODAL);
        this.init(string, string2, bl, diffPanel);
    }

    private void init(String string, String string2, boolean bl, DiffPanel diffPanel) {
        this.editor = diffPanel;
        this.timer = new Timer(500, this);
        this.timer.setRepeats(false);
        this.diffThread = new DiffThread(string, string2, bl);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.cancel.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.cancel, new GridBagConstraints());
        this.add(jPanel);
        String string3 = ResourceManager.getString((Object)ResourceKeyDiff.DIFF_MONITOR_MESSAGE);
        jPanel.add((Component)new JLabel(string3), "North");
        jPanel.add((Component)jPanel2, "Center");
        this.setSize(300, 150);
    }

    public void start() {
        this.diffThread.start();
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.timer) {
            if (this.result == null) {
                if (this.parentFrame != null && this.parentFrame.isShowing()) {
                    DialogUtilities.centerWindow(this, this.parentFrame);
                } else {
                    DialogUtilities.centerOnScreen(this);
                }
            }
        } else if (object == this.cancel) {
            this.diffThread.cancel();
        }
    }

    private void onDiffEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileDiffMonitorDialog.this.dispose();
                FileDiffMonitorDialog.this.editor.setContent(FileDiffMonitorDialog.this.result);
            }
        });
    }

    private class DiffThread
    extends Thread {
        private Cancellable cancellable = new CancellableImpl();
        private String leftText;
        private String rightText;
        private boolean ignoreLeadingSpaces;

        public DiffThread(String string, String string2, boolean bl) {
            this.leftText = string;
            this.rightText = string2;
            this.ignoreLeadingSpaces = bl;
        }

        public void cancel() {
            this.cancellable.cancel();
        }

        @Override
        public void run() {
            FileDiffResult fileDiffResult = Diff.diff(this.leftText, this.rightText, this.cancellable, this.ignoreLeadingSpaces);
            if (!this.cancellable.isCancelled()) {
                FileDiffMonitorDialog.this.result = fileDiffResult;
                if (FileDiffMonitorDialog.this.isShowing()) {
                    try {
                        Thread.sleep(800L);
                    }
                    catch (Exception exception) {}
                }
            } else {
                FileDiffMonitorDialog.this.result = Diff.quickDiff(this.leftText, this.rightText, this.ignoreLeadingSpaces);
            }
            FileDiffMonitorDialog.this.result = Diff.format(FileDiffMonitorDialog.this.result);
            FileDiffMonitorDialog.this.onDiffEnded();
        }
    }
}

