% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_data_completeness.R
\name{qc_data_completeness}
\alias{qc_data_completeness}
\title{Data completeness}
\usage{
qc_data_completeness(
  data,
  sample,
  grouping,
  intensity,
  digestion = NULL,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least the input variables.}

\item{sample}{a character or factor column in the \code{data} data frame that contains the sample names.}

\item{grouping}{a character column in the \code{data} data frame that contains either precursor
or peptide identifiers.}

\item{intensity}{a numeric column in the \code{data} data frame that contains any intensity
intensity values that missingness should be determined for.}

\item{digestion}{optional, a character column in the \code{data} data frame that indicates the
mode of digestion (limited proteolysis or tryptic digest). Alternatively, any other variable
by which the data should be split can be provided.}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is FALSE).}
}
\value{
A bar plot that displays the percentage of data completeness over all samples.
If \code{plot = FALSE} a data frame is returned. If \code{interactive = TRUE}, the plot is
interactive.
}
\description{
Calculates the percentage of data completeness. That means, what percentage of all detected
precursors is present in each sample.
}
\examples{
set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
)

# Determine data completeness
qc_data_completeness(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  plot = FALSE
)

# Plot data completeness
qc_data_completeness(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity = peptide_intensity_missing,
  plot = TRUE
)
}
