% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_coverage.R
\name{sequence_coverage}
\alias{sequence_coverage}
\title{Protein sequence coverage}
\usage{
sequence_coverage(data, protein_sequence, peptides)
}
\arguments{
\item{data}{A dataframe containing at least the protein sequence and the identified peptides as columns.}

\item{protein_sequence}{A column containing protein sequences, can be obtained by using the function \code{fetch_uniprot()}}

\item{peptides}{A column containing the identified peptides.}
}
\value{
A new column containing the calculated sequence coverages for each identified protein
}
\description{
Calculate sequence coverage for each identified protein.
}
\examples{
data <- data.frame(
  protein_sequence = c("abcdefghijklmnop", "abcdefghijklmnop"),
  pep_stripped_sequence = c("abc", "jklmn")
)

sequence_coverage(
  data,
  protein_sequence = protein_sequence,
  peptides = pep_stripped_sequence
)
}
