% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_uniprot.R
\name{fetch_uniprot}
\alias{fetch_uniprot}
\title{Fetch protein data from UniProt}
\usage{
fetch_uniprot(
  uniprot_ids,
  columns = c("protein names", "length", "sequence", "genes", "database(GeneID)",
    "database(String)", "go(molecular function)", "go(biological process)",
    "go(cellular compartment)", "interactor", "feature(ACTIVE SITE)",
    "feature(BINDING SITE)", "feature(METAL BINDING)", "chebi(Cofactor)",
    "chebi(Catalytic activity)", "database(PDB)"),
  batchsize = 200,
  show_progress = TRUE
)
}
\arguments{
\item{uniprot_ids}{A character vector of UniProt accession numbers}

\item{columns}{Metadata columns that should be imported from UniProt (all possible columns can be found \href{https://www.uniprot.org/help/uniprotkb_column_names}{here}.)}

\item{batchsize}{Size of batch of proteins for a single query}

\item{show_progress}{Logical, if true, a progress bar will be shown}
}
\value{
A data frame that contains all protein metadata specified in \code{columns} for the proteins provided. If an invalid ID
was provided that contains a valid UniProt ID, the valid portion of the ID is fetched and the invalid input ID is saved in a
column called \code{input_id}.
}
\description{
Fetches protein metadata from UniProt.
}
\examples{
\donttest{
fetch_uniprot(c("P36578", "O43324", "Q00796"))
}
}
