% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-02-readPDB.R
\name{readPDB}
\alias{readPDB}
\title{Read Protein Sequences in PDB Format}
\usage{
readPDB(file = system.file("protseq/4HHB.pdb", package = "protr"))
}
\arguments{
\item{file}{Path to the file containing the protein sequences in PDB format.
If it does not contain an absolute or
relative path, the file name is relative to the current
working directory, \code{\link{getwd}}.
The default here is to read the \code{4HHB.PDB} file which
is present in the \code{protseq} directory of the protr package.}
}
\value{
Character vector of the protein sequence.
}
\description{
This function reads protein sequences in PDB (Protein Data Bank) format,
and return the amino acid sequences represented by single-letter code.
}
\examples{
Seq4HHB <- readPDB(system.file("protseq/4HHB.pdb", package = "protr"))
}
\references{
Protein Data Bank Contents Guide: Atomic Coordinate Entry Format Description,
Version 3.30. Accessed 2013-06-26.
\url{https://ftp.wwpdb.org/pub/pdb/doc/format_descriptions/Format_v33_Letter.pdf}
}
\seealso{
See \code{\link{readFASTA}} for reading
protein sequences in FASTA format.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
