% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biproportional.R
\name{find_divisor}
\alias{find_divisor}
\title{Find divisor to assign seats}
\usage{
find_divisor(votes, divisor_from, divisor_to, target_seats, round_func)
}
\arguments{
\item{votes}{votes (matrix with only one column or vector, allows to use row/colnames
within \code{round_func})}

\item{divisor_from}{lower bound for divisor search range (is decreased if necessary)}

\item{divisor_to}{upper bound for divisor search range (is increased if necessary)}

\item{target_seats}{number of seats to distribute (single number)}

\item{round_func}{rounding function}
}
\value{
divisor
}
\description{
Find a divisor between \code{divisor_from} and \code{divisor_to} such as
\code{sum(round_func(votes/divisor))} equals \code{target_seats}
}
\keyword{internal}
