% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/111.ConfidenceIntervals_ADJ_n.R
\name{ciAAll}
\alias{ciAAll}
\title{CI estimation of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)  given adding factor}
\usage{
ciAAll(n, alp, h)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- adding factor}
}
\value{
A dataframe with
 \item{name }{- Name of the method}
 \item{x }{- Number of successes (positive samples)}
 \item{LLT }{ - Lower limit}
 \item{ULT }{ - Upper Limit}
 \item{LABB }{ - Lower Abberation}
 \item{UABB }{ - Upper Abberation}
 \item{ZWI }{ - Zero Width Interval}
}
\description{
CI estimation of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)  given adding factor
}
\details{
The Confidence Interval using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine) for \code{n} given \code{alp} and \code{h}
}
\examples{
n=5; alp=0.05;h=2
ciAAll(n,alp,h)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
\code{\link{prop.test} and \link{binom.test}} for equivalent base Stats R functionality,
   \code{\link[binom]{binom.confint}}  provides similar functionality for 11 methods,
   \code{\link[PropCIs]{wald2ci}} which provides multiple functions for CI calculation ,
   \code{\link[BlakerCI]{binom.blaker.limits}} which calculates Blaker CI which is not covered here and
   \code{\link[prevalence]{propCI}} which provides similar functionality.

Other Adjusted methods of CI estimation: \code{\link{PlotciAAS}},
  \code{\link{PlotciAAllg}}, \code{\link{PlotciAAll}},
  \code{\link{PlotciALR}}, \code{\link{PlotciALT}},
  \code{\link{PlotciASC}}, \code{\link{PlotciATW}},
  \code{\link{PlotciAWD}}, \code{\link{ciAAS}},
  \code{\link{ciALR}}, \code{\link{ciALT}},
  \code{\link{ciASC}}, \code{\link{ciATW}},
  \code{\link{ciAWD}}
}
