% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/pickapoint.R
\name{pickapoint}
\alias{pickapoint}
\title{Pick-A-Point Technique}
\usage{
pickapoint(model, dv, iv, mod, points, method = "meansd", alpha = 0.05)
}
\arguments{
\item{model}{regression model (lm).}

\item{dv}{dependent variable (character).}

\item{iv}{independent variable (character).}

\item{mod}{moderator variable(s) (character or character vector).}

\item{points}{list of points to test for each moderators (list).}

\item{method}{method to use. Possible values are: \code{"meansd", "percentiles"}, \code{centered="meansd"} by default.}

\item{alpha}{alpha level to use (numeric).}
}
\value{
A list with the elements
}
\description{
Probe moderation effect using the Pick-A-Point technique
}
\examples{
\dontrun{
myModel <- lm('dv ~ iv + mod', data=someData)
pickapoint(myModel, dv='DV', iv='IV', mod='MOD')
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', alpha=.01)
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', method='percentiles')
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', points=c(1,2,3))
}
}
\references{
Spiller, S. A., Fitzsimons, G. J., Lynch, J. G., Jr, & McClelland, G. H. (2013). Spotlights, floodlights, and the magic number zero: Simple effects tests in moderated regression. Journal of Marketing Research, 50(2), 277-288.

Aiken, L. S., & West, S. G. (1991). Multiple regression: Testing and interpreting interactions. Thousand Oaks, CA: Sage Publications.
}

