% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mix.R
\name{clr_mix}
\alias{clr_mix}
\title{Mixes a color into}
\usage{
clr_mix(col, mix_in, ratio = 0.5)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{mix_in}{A single color any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{ratio}{Numeric between 0 and 1. 0 will result on no mixing. 1 results
in all the colors turning to mix_in. Must be of length 1 or same length
as col.}
}
\value{
a colors object
}
\description{
Mixes a color into
}
\examples{
plot(clr_mix(rainbow(10), "blue"))

plot(clr_mix(rainbow(10), "red"))

plot(clr_mix(rainbow(10), "#5500EE"))

plot(clr_mix(rainbow(10), "black", seq(1, 0, length.out = 10)))
}
