% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConservationProblem-proto.R
\name{ConservationProblem-class}
\alias{ConservationProblem-class}
\alias{ConservationProblem}
\title{Conservation problem class}
\description{
This class is used to represent conservation planning problems. A
conservation planning problem has spatially explicit planning units.
A prioritization involves making a decision on each planning unit (e.g. is
the planning unit going to be turned into a protected area?). Each
planning unit is associated with a cost that represents the cost incurred
by applying the decision to the planning unit. The problem also has a set
of representation targets for each feature. Further, it also has
constraints used to ensure that the solution meets additional
objectives (e.g. certain areas are locked into the solution). Finally,
a conservation planning problem---unlike an optimization problem---also
requires a method to solve the problem. \strong{This class represents a
planning problem, to actually build and then solve a planning problem,
use the \code{\link[=problem]{problem()}} function. Only experts should use this
class directly.}
}
\section{Fields}{

\describe{

\item{$data}{\code{list} object containing data.}

\item{$objective}{\code{\linkS4class{Objective}} object used to represent how
the targets relate to the solution.}

\item{$decisions}{\code{\linkS4class{Decision}} object used to represent the
type of decision made on planning units.}

\item{$targets}{\code{\linkS4class{Target}} object used to represent
representation targets for features.}

\item{$penalties}{\code{\linkS4class{Collection}} object used to represent
additional \link{penalties} that the problem is subject to.}

\item{$constraints}{\code{\linkS4class{Collection}} object used to represent
additional \link{constraints} that the problem is subject to.}

\item{$portfolio}{\code{\linkS4class{Portfolio}} object used to represent
the method for generating a portfolio of solutions.}

\item{$solver}{\code{\linkS4class{Solver}} object used to solve the problem.}

}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$get_data(name)}

\code{x$set_data(name, value)}

\code{x$number_of_total_units()}

\code{x$number_of_planning_units()}

\code{x$planning_unit_indices()}

\code{x$planning_unit_indices_with_finite_costs()}

\code{x$planning_unit_costs()}

\code{x$number_of_features()}

\code{x$feature_names()}

\code{x$feature_abundances_in_planning_units()}

\code{x$feature_abundances_in_total_units()}

\code{x$feature_targets()}

\code{x$number_of_zones()}

\code{x$zone_names()}

\code{x$add_objective(obj)}

\code{x$add_decisions(dec)}

\code{x$add_portfolio(pol)}

\code{x$add_solver(sol)}

\code{x$add_constraint(con)}

\code{x$add_targets(targ)}

\code{x$get_constraint_parameter(id)}

\code{x$set_constraint_parameter(id, value)}

\code{x$get_objective_parameter(id)}

\code{x$set_objective_parameter(id, value)}

\code{x$get_solver_parameter(id)}

\code{x$set_solver_parameter(id, value)}

\code{x$get_portfolio_parameter(id)}

\code{x$set_portfolio_parameter(id, value)}

\code{x$get_penalty_parameter(id)}

\code{x$set_penalty_parameter(id, value)}
}

\section{Arguments}{


\describe{

\item{name}{\code{character} name for object.}

\item{value}{an object.}

\item{obj}{\code{\linkS4class{Objective}} object.}

\item{dec}{\code{\linkS4class{Decision}} object.}

\item{con}{\code{\linkS4class{Constraint}} object.}

\item{pol}{\code{\linkS4class{Portfolio}} object.}

\item{sol}{\code{\linkS4class{Solver}} object.}

\item{targ}{\code{\linkS4class{Target}} object.}

\item{cost}{\code{\linkS4class{RasterLayer}},
\code{\linkS4class{SpatialPolygonsDataFrame}}, or
\code{\linkS4class{SpatialLinesDataFrame}} object showing spatial
representation of the planning units and their cost.}

\item{features}{\code{\linkS4class{Zones}} or \code{data.frame} object
containing feature data.}

\item{id}{\code{Id} object that refers to a specific parameter.}

\item{value}{object that the parameter value should become.}

}
}

\section{Details}{

\describe{
\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{return \code{character} representation of the object.}

\item{get_data}{return an object stored in the \code{data} field with
the corresponding \code{name}. If the object is not present in the
\code{data} field, a \code{waiver} object is returned.}

\item{set_data}{store an object stored in the \code{data} field with
the corresponding name. If an object with that name already
exists then the object is overwritten.}

\item{number_of_planning_units}{\code{integer} number of planning units.}

\item{planning_unit_indices}{\code{integer} indices of the planning units in
the planning unit data.}

\item{planning_unit_indices_with_finite_costs}{\code{list} of \code{integer}
indices of planning units in each zone that have finite cost data.}

\item{number_of_total_units}{\code{integer} number of units in the cost
data including units that have \code{N} cost data.}

\item{planning_unit_costs}{\code{matrix} cost of allocating each planning
unit to each zone. Each column corresponds to a different zone and
each row corresponds to a different planning unit.}

\item{number_of_features}{\code{integer} number of features.}

\item{feature_names}{\code{character} names of features in problem.}

\item{feature_abundances_in_planning_units}{\code{matrix} total
abundance of each feature in planning units available in each zone. Each
column corresponds to a different zone and each row corresponds to a
different feature.}

\item{feature_abundances_in_total_units}{\code{matrix} total
abundance of each feature in each zone. Each column corresponds to a
different zone and each row corresponds to a different feature.}

\item{feature_targets}{\code{\link[tibble:tibble]{tibble::tibble()}} with feature targets.}

\item{number_of_zones}{\code{integer} number of zones.}

\item{zone_names}{\code{character} names of zones in problem.}

\item{add_objective}{return a new  \code{\linkS4class{ConservationProblem}}
with the objective added to it.}

\item{add_decisions}{return a new \code{\linkS4class{ConservationProblem}}
object with the decision added to it.}

\item{add_portfolio}{return a new \code{\linkS4class{ConservationProblem}}
object with the portfolio method added to it.}

\item{add_solver}{return a new \code{\linkS4class{ConservationProblem}} object
with the solver added to it.}

\item{add_constraint}{return a new \code{\linkS4class{ConservationProblem}}
object with the constraint added to it.}

\item{add_targets}{return a copy with the targets added to the problem.}

\item{get_constraint_parameter}{get the value of a parameter (specified by
argument \code{id}) used in one of the constraints in the object.}

\item{set_constraint_parameter}{set the value of a parameter (specified by
argument \code{id}) used in one of the constraints in the object to
\code{value}.}

\item{get_objective_parameter}{get the value of a parameter (specified by
argument \code{id}) used in the object's objective.}

\item{set_objective_parameter}{set the value of a parameter (specified by
argument \code{id}) used in the object's objective to \code{value}.}

\item{get_solver_parameter}{get the value of a parameter (specified by
argument \code{id}) used in the object's solver.}

\item{set_solver_parameter}{set the value of a parameter (specified by
argument \code{id}) used in the object's solver to \code{value}.}

\item{get_portfolio_parameter}{get the value of a parameter (specified by
argument \code{id}) used in the object's portfolio.}

\item{set_portfolio_parameter}{set the value of a parameter (specified by
argument \code{id}) used in objects' solver to \code{value}.}

}
}

