% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_neighbor_contraints.R
\name{add_neighbor_constraints}
\alias{add_neighbor_constraints}
\title{Add neighbor constraints}
\usage{
add_neighbor_constraints(x, k, ...)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{k}{\code{integer} number of neighbors each selected planning units
must have.}

\item{...}{arguments passed to \code{\link{connected_matrix}}.}
}
\value{
\code{\link{ConservationProblem-class}} object with the constraint
  added to it.
}
\description{
Add constraints to a conservation problem to ensure that all selected
planning units have at least a certain number of neighbors.
}
\details{
The mathematical ideas that underpin this function inspired by
Billionnet (2013).
}
\examples{
# create basic problem
p1 <- problem(sim_pu_polygons, sim_features, "cost") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2)

# create problem with constraints that require 1 neighbor
p2 <- p1 \%>\% add_neighbor_constraints(1)

# create problem with constraints that require 2 neighbors
p3 <- p1 \%>\% add_neighbor_constraints(2)

# create problem with constraints that require 3 neighbors
p4 <- p1 \%>\% add_neighbor_constraints(3)

\donttest{
# solve problems
s <- list(solve(p1), solve(p2), solve(p3), solve(p4))

# plot solutions
par(mfrow = c(2,2), mar = c(0, 0, 4.1, 0))

plot(s[[1]], main = "basic solution")
plot(s[[1]][s[[1]]$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s[[2]], main="1 neighbor")
plot(s[[2]][s[[2]]$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s[[3]], main="2 neighbors")
plot(s[[3]][s[[3]]$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s[[4]], main="3 neighbors")
plot(s[[4]][s[[4]]$solution_1 == 1, ], col = "darkgreen", add = TRUE)
}

}
\references{
Billionnet A (2013) Mathematical optimization ideas for biodiversity
conservation. \emph{European Journal of Operational Research}, 231:
514--534.
}
\seealso{
\code{\link{constraints}} for all the available constraints,
 and \code{\link{penalties}}.
}
