% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateIfunctions.R
\name{calculate_I_smooth}
\alias{calculate_I_smooth}
\title{Estimate the incidence based on PPS data using monotone estimators for the distribution of A.}
\usage{
calculate_I_smooth(data, method = "gren", correct.one.loi = "no",
  correct.one.los = "no")
}
\arguments{
\item{data}{data frame which contains a column `A.loi` 
with lengths of nosocomial infections up to survey point ( zero if none) and
possibly a column `A.los` with length of stay up to survey point}

\item{method}{method to use for smoothing ("gren" ( Grenander ) or "rear" (rearrangement))}

\item{correct.one.loi}{use correction for underreporting of one day LOIs:
"no" if none, "fill.ones" to set the one-day cases to be at least the number
 of two-day cases, "start.two" to only use P(A=2| A > 1) as a proxy for P(A=1)}

\item{correct.one.los}{use correction for underreporting of one day LOSs:
"no" if none, "fill.ones" to set the one-day cases to be at least the number
 of two-day cases, "start.two" to only use P(A=2| A > 1) as a proxy for P(A=1)}
}
\value{
one-row data frame with following columns \itemize{
   \item{n - }{number of patients sampled} 
   \item{n.noso - }{number of HAIs}
   \item{P.hat - }{estimate of prevalence P}
   \item{I.hat - }{estimate of incidence rate I}
   \item{I.pp.hat - }{estimate of incidence proportion per admission I.pp}
   \item{x.loi.hat - }{estimate of x.loi}
   \item{x.los.hat - }{estimate of x.los}
   \item{method - }{name of the method}
}
}
\description{
Estimate incidence from PPS by the method proposed in the companion paper.
`data` should be supplied as a data frame with at least a column named `A.loi`
giving lengths of infection up to date of PPS.
Values of zero for `A.loi` indicate absence of a HAI. Optionally,
the data frame can also contain a column `A.los` supplying lengths
of stay up to PPS to estimate x.los with the same method as well.
If `correct.one` is `TRUE`, the number infections on their first day
will be augmented to be at least as high as the number of infections
on their second day for the estimation of x.loi .
}
\examples{

# create example data for PPS
example.dist <- create_dist_vec(function(x) dpois(x-1, 7), max.dist = 70)
example.dist.los <- create_dist_vec(function(x) dpois(x-1, lambda = 12),
                                    max.dist = 70)
data.pps.fast <- simulate_pps_fast(n.sample=200,
                                   P=0.05,
                                   dist.X.loi = example.dist,
                                   dist.X.los = example.dist.los)
head(data.pps.fast)

# estimate of incidence
calculate_I_smooth(data = data.pps.fast,
                   method = "gren")


}
