% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{edit_mask}
\alias{edit_mask}
\title{Edit mask}
\usage{
edit_mask(
  pressure_data,
  n_edit,
  threshold = 0.002,
  edit_list = seq(1, length(pressure_data[[5]])),
  image = "max"
)
}
\arguments{
\item{pressure_data}{List. First item is a 3D array covering each timepoint
of the measurement.}

\item{n_edit}{Numeric. Number of vertices to edit}

\item{threshold}{Numeric. Distance between point clicked and vertex that is
selected}

\item{edit_list}{List. Mask numbers that want to be edited. (Default is to
load all masks so that adjacent masks with shared coordinates are modified
together)}

\item{image}{String."max" = footprint of maximum sensors. "mean"
average value of sensors over time}
}
\value{
List. Edited mask is added to the pressure data variable
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
 }
}
\description{
Allows user to manually adjust mask vertices
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- automask(pressure_data, foot_side = "auto", plot = TRUE)
pressure_data <- edit_mask(pressure_data, n_edit = 1, threshold = 0.002,
  edit_list = seq(1,length(pressure_data[[5]])), image = "max")
\dontshow{\}) # examplesIf}
}
