% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_fast.R
\name{cv_fast}
\alias{cv_fast}
\title{Evaluate Trait Predictability via the HAT Method}
\usage{
cv_fast(fix = NULL, y, kk, nfold = 5, seed = 123)
}
\arguments{
\item{fix}{a design matrix of the fixed effects. If not passed, a vector of ones is added for the intercept.}

\item{y}{a vector of the phenotypic values.}

\item{kk}{a list of one or multiple kinship matrices.}

\item{nfold}{the number of folds, default is 5. For the HAT Method, nfold can be set as the sample size (leave-one-out CV) to avoid
variation caused by random partitioning of the samples, but it is not recommended for \code{\link{cv}}.}

\item{seed}{the random number, default is 123.}
}
\value{
Trait predictability
}
\description{
The HAT method is a fast algorithm for the ordinary cross validation. It is highly recommended for large dataset (Xu et al. 2017).
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)

## convert original genotype
inbred_gen <- convertgen(input_geno, type = "hmp2")

## infer the additive and dominance genotypes of hybrids
gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

## calculate the additive and dominance kinship matrix
ka <- kin(gena)
kd <- kin(gend)

##for the additive model
predictability <- cv_fast(y = hybrid_phe[,3], kk = list(ka))

##for the additive-dominance model
predictability <- cv_fast(y = hybrid_phe[,3], kk = list(ka,kd))
}

}
\references{
Xu S. (2017) Predicted residual error sum of squares of mixed models: an application for genomic prediction. G3 (Bethesda) 7, 895-909.
}
