% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossv.R
\name{balance.split}
\alias{balance.split}
\title{Split the given dataset into balanced training and validation sets
(within a pre-specified tolerance)
Balanced means 1) The ratio of treated and controls is maintained in the training and validation sets
               2) The covariate distributions are balanced between the training and validation sets}
\usage{
balance.split(
  y,
  trt,
  x.cate,
  x.ps,
  time,
  minPS = 0.01,
  maxPS = 0.99,
  train.prop = 3/4,
  error.max = 0.1,
  max.iter = 5000
)
}
\arguments{
\item{y}{Observed outcome; vector of size \code{n} (observations)}

\item{trt}{Treatment received; vector of size \code{n} with treatment coded as 0/1}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} by \code{p.cate}
(covariates in the outcome model)}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates (plus a leading column of 1 for the intercept);
dimension \code{n} by \code{p.ps + 1} (covariates in the propensity score model plus intercept)}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in (0, 1]) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}

\item{train.prop}{A numerical value (in (0, 1)) indicating the proportion of total data used
for training. Default is \code{3/4}.}

\item{error.max}{A numerical value > 0 indicating the tolerance (maximum value of error)
for the largest standardized absolute difference in the covariate distributions or in the
doubly robust estimated rate ratios between the training and validation sets. This is used
to define a balanced training-validation splitting. Default is \code{0.1}.}

\item{max.iter}{A positive integer value indicating the maximum number of iterations when
searching for a balanced training-validation split. Default is \code{5,000}.}
}
\value{
A list of 10 objects, 5 training and 5 validation of y, trt, x.cate, x.ps, time:
            y.train          - observed outcome in the training set; vector of size \code{m} (observations in the training set)
            trt.train        - treatment received in the training set; vector of size \code{m} coded as 0/1
            x.cate.train     - baseline covariates for the outcome model in the training set; matrix of dimension \code{m} by \code{p.cate}
            x.ps.train       - baseline covariates (plus intercept) for the propensity score model in the training set; matrix of dimension \code{m} by \code{p.ps + 1}
            time.train       - log-transformed person-years of follow-up in the training set; vector of size \code{m}
            y.valid          - observed outcome in the validation set; vector of size \code{n-m}
            trt.valid        - treatment received in the validation set; vector of size \code{n-m} coded as 0/1
            x.cate.valid     - baseline covariates for the outcome model in the validation set; matrix of dimension \code{n-m} by \code{p.cate}
            x.ps.valid       - baseline covariates (plus intercept) for the propensity score model in the validation set; matrix of dimension \code{n-m} by \code{p.ps + 1}
            time.valid       - log-transformed person-years of follow-up in the validation set; vector of size \code{n-m}
}
\description{
Split the given dataset into balanced training and validation sets
(within a pre-specified tolerance)
Balanced means 1) The ratio of treated and controls is maintained in the training and validation sets
               2) The covariate distributions are balanced between the training and validation sets
}
