\name{prabclust}
\alias{prabclust}
\alias{print.prabclust}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Clustering of species ranges from presence-absence matrices
  (mixture method)}
\description{
  Clusters a presence-absence matrix object by calculating an MDS from
  the distances, and applying maximum likelihood Gaussian mixtures clustering
  with "noise" (package \code{mclust}) to the MDS points. The solution
  is plotted. A standard execution will be \cr
  \code{prabmatrix <- prabinit(file="path/prabmatrixfile",
    neighborhood="path/neighborhoodfile")}\cr
  \code{clust <- prabclust(prabmatrix)}\cr
  \code{print(clust)} \cr
  \bold{Note:} Data formats are described
  on the \code{prabinit} help page. You may also consider the example datasets
  \code{kykladspecreg.dat} and \code{nb.dat}. Take care of the
  parameter \code{rows.are.species} of \code{prabinit}.
}

\usage{
prabclust(prabobj, mdsmethod = "classical", mdsdim = 4, nnk =
ceiling(prabobj$n.species/40), nclus = 0:9, modelid = "all")

\method{print}{prabclust}(x, bic=FALSE, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{prabobj}{object of class \code{prab} as
    generated by \code{prabinit}. Presence-absence data to be analyzed.
  }
  \item{mdsmethod}{\code{"classical"}, \code{"kruskal"}, or
    \code{"sammon"}. The MDS method
    to transform the distances to data points. \code{"classical"} indicates
    metric MDS by function \code{cmdscale}, \code{"kruskal"} is
    non-metric MDS.}
  \item{mdsdim}{integer. Dimension of the MDS points.}
  \item{nnk}{integer. Number of nearest neighbors to determine the
    initial noise estimation by \code{NNclean}.}
  \item{nclus}{vector of integers. Numbers of clusters to perform the
    mixture estimation.}
  \item{modelid}{string. Model name for \code{EMclustN} (see the
    corresponding help page). \code{modelid="all"} compares all possible
    models. Additionally, \code{"noVVV"} is possible, which
    fits all methods except \code{"VVV"}.}
  \item{x}{object of class \code{prabclust}. Output of
    \code{prabclust}.}
  \item{bic}{logical. If \code{TRUE}, information about the BIC
    criterion to choose the model is displayed.}
  \item{...}{necessary for summary method.}
}

\value{
  \code{print.prabclust} does not produce output. 
  \code{prabclust} generates an object of class \code{prabclust}. This is a
  list with components
  \item{clustering}{vector of integers indicating the cluster memberships of
    the species. Noise can be recognized by output component \code{symbols}.}
  \item{clustsummary}{output object of \code{summary.EMclustN}. A list
    giving the optimal (according to BIC) parameters, 
    conditional probabilities `z', and loglikelihood, together with
    the associated classification and its uncertainty.}
  \item{bicsummary}{output object of \code{EMclustN}. Bayesian Information
    Criterion for the specified mixture models and numbers of clusters. }
  \item{points}{numerical matrix. MDS configuration.}
  \item{nnk}{see above.}
  \item{mdsdim}{see above.}
  \item{mdsmethod}{see above.}
  \item{symbols}{vector of characters, similar to \code{clustering}, but
    indicating estimated noise and points belonging to
    one-point-components (which should be interpreted as some kind of
    noise as well) by \code{"N"}. } 
}
\references{
Hennig, C. and Hausdorf, B. (2004) Distance-based parametric bootstrap
tests for clustering of species ranges. \emph{Computational Statistics
  and
  Data Analysis} 45, 875-896.
\url{http://stat.ethz.ch/Research-Reports/110.html}.
}
\note{
  Note that we used \code{mdsmethod="kruskal"} in our publications, but
  we prefer the new default \code{mdsmethod="classical"} now, because we
  discovered some numerical instabilities of the
  \code{isoMDS}-implementation in connection with our distance matrices.

  Sometimes, \code{prabclust} produces an error because \code{EMclustN}
  cannot handle all models properly. In this case we recommend to change
  the \code{modelid} parameter. \code{"noVVV"} and \code{"VVV"} are
  reasonable alternative choices (one of these is expected to reproduce
  the error, but the other one might work).
  }

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link[mclust]{EMclustN}}, \code{\link[mclust]{summary.EMclustN}},
  \code{\link{NNclean}}, \code{\link{cmdscale}},
  \code{\link{isoMDS}}, \code{\link{sammon}},
  \code{\link{prabinit}}, \code{\link{hprabclust}}.
}

\examples{
data(kykladspecreg)
# Note: If you do not use the installed package, replace this by
# kykladspecreg <- read.table("(path/)kykladspecreg.dat")
data(nb)
# Note: If you do not use the installed package, replace this by
# nb <- list()
# for (i in 1:34)
#   nb <- c(nb,list(scan(file="(path/)nb.dat",
#                   skip=i-1,nlines=1)))
set.seed(1234)
x <- prabinit(prabmatrix=kykladspecreg, neighborhood=nb)
# If you want to use your own ASCII data files, use
# x <- prabinit(file="path/prabmatrixfile",
# neighborhood="path/neighborhoodfile")
print(prabclust(x))
}
\keyword{cluster}% at least one, from doc/KEYWORDS
\keyword{spatial}% __ONLY ONE__ keyword per line
