\name{autoconst}
\alias{autoconst}
\alias{autoreg}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Spatial autocorrelation parameter estimation}
\description{
  Monte Carlo estimation of the disjunction/spatial autocorrelation
  parameter \code{pd} for the simulation model used in
  \code{randpop.nb}, used for tests for clustering of presence-absence data.

  \code{autoconst} is the main function; \code{autoreg} performs the
  simulation and is executed within \code{autoconst}.
}
\usage{
autoconst(x, prange = c(0, 1), twostep = TRUE, step1 = 0.1,
step2 = 0.01, plot = TRUE, nperp = 4, ejprob = NULL,
species.fixed = TRUE, pdfnb=FALSE)

autoreg(x, probs, ejprob, plot = TRUE, nperp = 4, species.fixed = TRUE,
pdfnb=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{object of class \code{prab} as generated by \code{prabinit}.
    Presence-absence data to be analyzed.}
  \item{prange}{numerical range vector, lower value not smaller than 0, larger
    value not larger than 1. Range where the parameter is to be found.}
  \item{twostep}{logical. If \code{TRUE}, a first estimation step is
    carried out in the whole \code{prange}, and then the final
    estimation is determined between the preliminary estimator
    \code{-5*step2} and {+5*step2}. Else, the first simulation
    determines the final estimator.}
  \item{step1}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the first simulation.}
  \item{step2}{numerical between 0 and 1. Interval length between
    subsequent choices of \code{pd} for the second simulation in case of
    \code{twostep=TRUE}.}
  \item{plot}{logical. If \code{TRUE}, a scatterplot of \code{pd}-values
    against resulting \code{ejprob} values (see below), with regression
    line and data value of \code{ejprob} is shown.}
  \item{nperp}{integer. Number of simulations per \code{pd}-value.}
  \item{ejprob}{numerical between 0 and 1. Observed disjunction
    probability for data \code{x}; if not specified in advance,
    it will be computed by \code{autoconst}.}
  \item{species.fixed}{logical. If \code{TRUE}, sizes of generated
    species match the species sizes in \code{x}, else they are generated
    from the empirical distribution of species sizes in \code{x}.}
  \item{probs}{vector of numericals between 0 and 1. \code{pd} values
    for the simulation.}
  \item{pdfnb}{logical. If \code{TRUE}, the probabilities of the regions
    are modified according to the number of neighboring regions in
    \code{randpop.nb}, see Hennig and Hausdorf (2002), p. 5.}
}
\details{
  The spatial autocorrelation parameter \code{pd}
  of the model for the generation of
  presence-absence data sets used by \code{randpop.nb} can be estimated
  by use of the observed disjuction probability \code{ejprob} which is
  the sum of
  all species' connectivity components minus the number of species
  divided by the number of "presence" entries minus the number of
  species. This is done by a simulation of artificial data sets with
  characteristics of \code{x} and different \code{pd}-values, governed
  by \code{prange, step1, step2} and \code{nperp}. \code{ejprob} is then
  calculated for all simulated populations. A linear regression of
  \code{ejprob} on \code{pd} is performed and the estimator of \code{pd}
  is determined by computing the inverse of the regression function for
  the \code{ejprob}-value of \code{x}. 
}
\value{
  \code{autoconst} produces the same list as \code{autoreg} with
  additional component \code{ejprob}. The components are 
  \item{pd}{(eventually) estimated parameter \code{pd}.}
  \item{coef}{(eventually) estimated regression coefficients.}
  \item{ejprob}{see above.}
}
\references{
Hennig, C. and Hausdorf, B. (2002) Distance-based parametric bootstrap
tests for clustering of species ranges, submitted,
\url{http://stat.ethz.ch/Research-Reports/110.html}.

Hausdorf, B. and Hennig, C. (2003)  Biotic Element Analysis in
Biogeography. To appear in  \emph{Systematic Biology}.

Hausdorf, B. and Hennig, C. (2003) Nestedness of nerth-west European
land snail ranges as a consequence of differential immigration from
Pleistocene glacial refuges. \emph{Oecologia} 135, 102-109.

}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link{randpop.nb}}, \code{\link{prabinit}}, \code{\link{con.comp}} 
}

\examples{
data(kykladspecreg)
# Note: If you do not use the installed package, replace this by
# kykladspecreg <- read.table("(path/)kykladspecreg.dat")
data(nb)
# Note: If you do not use the installed package, replace this by
# nb <- list()
# for (i in 1:34)
#   nb <- c(nb,list(scan(file="(path/)nb.dat",
#                   skip=i-1,nlines=1)))
set.seed(1234)
x <- prabinit(prabmatrix=kykladspecreg, neighborhood=nb)
ax <- autoconst(x,nperp=2,step1=0.3,twostep=FALSE)
}
\keyword{spatial}% at least one, from doc/KEYWORDS

