% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PQRFE_main.R
\name{clean_data}
\alias{clean_data}
\title{Clean missings}
\usage{
clean_data(y, x, id)
}
\arguments{
\item{y}{Numeric vector, outcome.}

\item{x}{Numeric matrix, covariates}

\item{id}{Numeric vector, identifies the unit to which the observation belongs.}
}
\value{
list with the same objects y, x, id, but without missings.
}
\description{
Clean missings
}
\examples{
n = 10
m = 4
d = 3
N = n*m
L = N*d
x = matrix(rnorm(L), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = x \%*\% beta  + matrix(rep(alpha, each=m) + eps)
y = as.vector(y)
x[1,3] = NA
clean_data(y=y, x=x, id=subj)  
 
}
