% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiPAK2009}
\alias{ppiPAK2009}
\title{ppiPAK2009}
\format{A data frame with 10 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl50}}{National poverty line (50\%)}
\item{\code{nl75}}{National poverty line (75\%)}
\item{\code{nl125}}{National poverty line (125\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Poorest half below 100 national}
\item{\code{ppp250}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $2.50 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiPAK2009
}
\description{
Poverty Probability Index (PPI) lookup table for Pakistan
}
\examples{
  # Access Pakistan PPI table
  ppiPAK2009

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiPAK2009[ppiPAK2009$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiPAK2009, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiPAK2009[ppiPAK2009$score == ppiScore, "nl100"]

}
\keyword{datasets}
