% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{postPPalpha}
\alias{postPPalpha}
\alias{postPPalphaHPD}
\title{Marginal posterior distribution of power parameter}
\usage{
postPPalpha(alpha, tr, sr, to, so, x = 1, y = 1, m = 0, v = Inf, ...)

postPPalphaHPD(level = 0.95, tr, sr, to, so, x = 1, y = 1, m = 0, v = Inf, ...)
}
\arguments{
\item{alpha}{Power parameter. Can be a vector.}

\item{tr}{Effect estimate of the replication study.}

\item{sr}{Standard error of the replication effect estimate.}

\item{to}{Effect estimate of the original study.}

\item{so}{Standard error of the replication effect estimate.}

\item{x}{Number of successes parameter of beta prior \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{y}{Number of failures parameter of beta prior \eqn{\alpha}{alpha}.
Defaults to \code{1}.}

\item{m}{Mean parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{0}.}

\item{v}{Variance parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{Inf} (uniform prior).}

\item{...}{Additional arguments passed to \code{stats::integrate}.}

\item{level}{Credibility level of the highest posterior density interval.
Defaults to \code{0.95}.}
}
\value{
\code{postPPalpha} returns the marginal posterior density of the power
    parameter.

\code{postPPalphaHPD} returns the highest marginal posterior density
    interval of the power parameter.
}
\description{
These functions compute the marginal posterior of the power
    parameter \eqn{\alpha}{alpha}. A power prior for \eqn{\theta}{theta} is
    constructed by updating an initial normal prior \eqn{\theta \sim
    \mathrm{N}(\code{m}, \code{v})}{theta ~ N(m, v)} with the likelihood of
    the original data raised to the power of \eqn{\alpha}{alpha}. A marginal
    beta prior \eqn{\alpha \sim \mbox{Beta}(\code{x},\code{y})}{alpha ~
    Beta(x, y)} is assumed.
}
\examples{
alpha <- seq(0, 1, 0.001)
margpostdens <- postPPalpha(alpha = alpha, tr = 0.1, to = 0.2, sr = 0.05, so = 0.05)
plot(alpha, margpostdens, type = "l", xlab = bquote("Power parameter" ~ alpha),
     ylab = "Marginal posterior density", las = 1)
}
\seealso{
\code{\link{postPP}}, \code{\link{postPPtheta}}, \code{\link{plotPP}}
}
\author{
Samuel Pawel
}
