% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.parallel.cont.R
\name{crt.parallel.cont}
\alias{crt.parallel.cont}
\title{Power for cluster randomized trial with continuous outcome}
\usage{
crt.parallel.cont(
  m = NULL,
  m.sd = 0,
  J1 = NULL,
  J.ratio = 1,
  delta = NULL,
  sd = 1,
  icc1 = 0,
  icc2 = 0,
  ncov = 0,
  RsqB = 0,
  RsqW = 0,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects per cluster or the mean cluster size (if unequal number of participants per cluster).}

\item{m.sd}{The standard deviation of cluster sizes (provide if unequal number of participants per cluster); defaults to 0.}

\item{J1}{The number of clusters in arm 1.}

\item{J.ratio}{The ratio J2/J1 between the number of clusters in the two arms; defaults to 1 (equal clusters per arm).}

\item{delta}{The difference between the intervention and control means under the alternative minus the difference under the null hypothesis.}

\item{sd}{The total standard deviation of the outcome variable; defaults to 1.}

\item{icc1}{The intraclass correlation coefficient in arm 1; defaults to 0.}

\item{icc2}{The intraclass correlation coefficient in arm 2; defaults to 0.}

\item{ncov}{The number of cluster-level and individual-level covariates; defaults to 0.}

\item{RsqB}{The estimated proportion of total variance explained by cluster-level covariates; defaults to 0.}

\item{RsqW}{The estimated proportion of total variance explained by individual-level covariates; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for a two-arm cluster randomized trial
with a continuous, normal outcome. Can solve for power, J1, J.ratio, m or alpha.
}
\examples{
crt.parallel.cont(m = 30, J1 = 8, delta = 0.4, icc1 = 0.05, icc2 = 0.05)
crt.parallel.cont(m = NULL, J1 = 6, delta = 0.5, icc1 = 0.05, icc2 = 0.05, power = 0.8)
crt.parallel.cont(m = 25, m.sd = 15, J1 = NULL, delta = 0.3, icc1 = 0.05,
icc2 = 0.05, power = 0.8)
crt.parallel.cont(m = 20, J1 = 15, delta = 0.3, icc1 = 0.05, icc2 = 0.05,
RsqB = 0.1, ncov = 1, sides = 1)
}
