% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.means.r.R
\name{crt.means.r}
\alias{crt.means.r}
\title{Correlation between a cluster mean at baseline and follow up}
\usage{
crt.means.r(m, icc, cac, sac)
}
\arguments{
\item{m}{The number of measurements in each cluster at baseline and follow up.}

\item{icc}{The intraclass correlation coefficient.}

\item{cac}{The cluster autocorrelation.}

\item{sac}{The subject autocorrelation.}
}
\value{
The computed correlation.
}
\description{
For a cluster randomized trial with a continuous outcome, this function calculates the correlation
between a cluster's mean at baseline and at follow up based on various inputs.
For cross-sectional sampling of subjects,
that is, different subjects are measured at baseline and follow up, specify sac = 0.
}
\examples{
crt.means.r(m = 30, icc = 0.05, cac = 0.4, sac = 0.5)
}
