% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg.R
\name{bkg}
\alias{bkg}
\title{Fit a background to XRPD data}
\usage{
bkg(xrd, lambda, hwi, it, int)
}
\arguments{
\item{xrd}{an xy data frame of the data to fit a background to. First column
is the 2theta scale, second column is count intensities}

\item{lambda}{second derivative penalty for primary smoothing. Default = 0.5.}

\item{hwi}{Half width of local windows. Default = 25.}

\item{it}{Number of iterations in suppression loop. Default = 50.}

\item{int}{Number of buckets to divide the data into. Default = \code{round(nrow(xrd)/4)}.}
}
\value{
a powdRbkg object consisting of of 3 vectors
\item{tth}{The 2theta axis of the measurement}
\item{counts}{The count intensities of the measurement}
\item{background}{The count intensities of the fitted background}
}
\description{
\code{bkg} fits a background to X-Ray Powder Diffraction data
}
\details{
A wrapper for the \code{baseline.fillPeaks} in the \code{baseline} package.
}
\examples{
data(soils)
\dontrun{
fit_bkg <- bkg(soils$granite)
plot(bkg)
}
}
