% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pour.R
\name{pour}
\alias{pour}
\alias{pour_package}
\alias{pour_interactive}
\alias{pour_all}
\title{Retrieve information stored using \code{potions::brew()}}
\usage{
pour(..., .slot, .pkg)

pour_package(..., .pkg)

pour_interactive(..., .slot)

pour_all()
}
\arguments{
\item{...}{string: what slots should be returned}

\item{.slot}{string: Optional manual override to default slot}

\item{.pkg}{string: Optional manual override to default package}
}
\value{
If no arguments are passed to \code{...}, returns a \code{list} from the
default slot. If \code{...} is supplied (correctly), then returns a \code{vector} of
values matching those names.
}
\description{
This is the main function that most users will call on. It retrieves data
from a \code{potions} object stored using \code{brew()}. The UI for this function is
based on the \code{here} package, in that it uses list names separated by commas
to navigate through nested content. It differs from \code{here} in not requiring
those names to be quoted.
}
\details{
Providing multiple arguments to \code{...} brings back nested values,
i.e. \code{pour("x", "y")} is for the case of an object structured as
\code{list(x = list(y = 1))}, rather than \code{list(x = 1, y = 2)}. For the latter
case it would be necessary to call with either no arguments
(\code{unlist(pour())}), or for greater control, call pour multiple times
specifying different entries each time (e.g. \code{z <- c(pour("x"), pour("y"))}).

Additional functions are provided in case greater specificity is required.
\code{pour_interactive(.slot = ...)} is synonymous with \code{pour(.slot = ...)}, while
\code{pour_package(.pkg = ...)} is synonymous with \code{pour(.pkg = ...)}.
\code{pour_all()} is a shortcut for \code{getOption("potions-pkg")}; i.e. to show all
data stored using \code{potions} by any package or slot, and does not accept any
arguments.
}
\examples{
# first import some data
brew(x == 1, y == list(a = 2, b = 3))

# get all data
pour()

# get only data from slot x
pour(x)

# get nested data
pour(y, a)

# optional clean-up
drain()
}
