% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.draws_matrix}
\alias{print.draws_matrix}
\title{Print \code{draws_matrix} objects}
\usage{
\method{print}{draws_matrix}(
  x,
  digits = 2,
  max_draws = getOption("posterior.max_draws", 10),
  max_variables = getOption("posterior.max_variables", 8),
  reserved = FALSE,
  ...
)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{digits}{(nonnegative integer) The minimum number of significant digits
to print.}

\item{max_draws}{(positive integer) The maximum number of draws to print. Can
be controlled globally via the \code{"posterior.max_draws"}
\link[base:options]{option}.}

\item{max_variables}{(positive integer) The maximum number of variables to
print. Can be controlled globally via the \code{"posterior.max_variables"}
\link[base:options]{option}.}

\item{reserved}{(logical) Should reserved variables be included in the
output? Defaults to \code{FALSE}. See \code{\link{reserved_variables}} for an overview of
currently reserved variable names.}

\item{...}{Further arguments passed to the underlying \code{\link[=print]{print()}} methods.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Pretty printing for \code{\link{draws_matrix}} objects.
}
\examples{
x <- as_draws_matrix(example_draws())
print(x)

}
