## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message = FALSE---------------------------------------------------
library(postcard)
withr::local_seed(1395878)
withr::local_options(list(postcard.verbose = 0))

## ----dat-sim------------------------------------------------------------------
n <- 1000
b0 <- 1
b1 <- 3
b2 <- 2

# Simulate data with a non-linear effect
dat_treat <- glm_data(
  Y ~ b0+b1*sin(W)^2+b2*A,
  W = runif(n, min = -2, max = 2),
  A = rbinom(n, 1, prob = 1/2),
  family = gaussian() # Default value
)

## ----noprog-run---------------------------------------------------------------
ate <- rctglm(formula = Y ~ A * W,
              exposure_indicator = A,
              exposure_prob = 1/2,
              data = dat_treat,
              family = "gaussian") # Default value

## ----noprog-show--------------------------------------------------------------
ate

## -----------------------------------------------------------------------------
est(ate)

## ----hist-data----------------------------------------------------------------
dat_notreat <- glm_data(
  Y ~ b0+b1*sin(W)^2,
  W = runif(n, min = -2, max = 2),
  family = gaussian # Default value
)

## ----prog-run-----------------------------------------------------------------
ate_prog <- rctglm_with_prognosticscore(
  formula = Y ~ A * W,
  exposure_indicator = A,
  exposure_prob = 1/2,
  data = dat_treat,
  family = gaussian(link = "identity"), # Default value
  data_hist = dat_notreat)

## ----prog-show----------------------------------------------------------------
ate_prog

## -----------------------------------------------------------------------------
pred_mod <- glm(Y ~ W + A, data = dat_treat)
preds <- predict(pred_mod, dat_treat)

power_marginaleffect(
  response = dat_treat$Y,
  predictions = preds,
  target_effect = 0.4,
  exposure_prob = 1/2
)

## -----------------------------------------------------------------------------
vanc <- variance_ancova(Y ~ A + W, data = dat_treat)
vanc

## -----------------------------------------------------------------------------
power_gs(variance = vanc, n = 100, ate = 0.8)
power_nc(variance = vanc, n = 100, df = 97, ate = 0.8)
samplesize_gs(variance = vanc, ate = 0.8, power = 0.9)

