% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{port4me.settings}
\alias{port4me.settings}
\alias{PORT4ME_DEBUG}
\alias{PORT4ME_TOOL}
\alias{PORT4ME_USER}
\alias{PORT4ME_SKIP}
\alias{PORT4ME_PREPEND}
\alias{PORT4ME_INCLUDE}
\alias{PORT4ME_EXCLUDE}
\alias{PORT4ME_PREPEND_SITE}
\alias{PORT4ME_INCLUDE_SITE}
\alias{PORT4ME_EXCLUDE_SITE}
\alias{PORT4ME_EXCLUDE_UNSAFE}
\alias{PORT4ME_EXCLUDE_UNSAFE_CHROME}
\alias{PORT4ME_EXCLUDE_UNSAFE_FIREFOX}
\title{Settings Used by the 'port4me' Package}
\description{
Below are the environment variables that are used by the \pkg{port4me}
package and packages enhancing it.\cr
\cr
\emph{WARNING: Note that the names and the default values of these settings
may change in future versions of the package.  Please use with care
until further notice.}
}
\details{
\describe{
\item{\code{PORT4ME_EXCLUDE}:}{
Controls the default value for argument \code{exclude} of \code{\link[=port4me]{port4me()}}.
Ports and port sequences should be separated by commas.
Port sequences should be specified as a start and end port separated
by a hyphen.
Example: \verb{PORT4ME_EXCLUDE=4444,5000-5999,8080}.
(Default: empty)
}

\item{\code{PORT4ME_INCLUDE}:}{
Controls the default value for argument \code{include} of \code{\link[=port4me]{port4me()}}.
The format should be the same as for \code{PORT4ME_INCLUDE}.
(Default: empty)
}

\item{\code{PORT4ME_PREPEND}:}{
Controls the default value for argument \code{prepend} of \code{\link[=port4me]{port4me()}}.
The format should be the same as for \code{PORT4ME_INCLUDE}.
(Default: empty)
}

\item{\code{PORT4ME_SKIP}:}{
Controls the default value for argument \code{skip} of \code{\link[=port4me]{port4me()}}.
(Default: \code{0})
}

\item{\code{PORT4ME_TOOL}:}{
Controls the default value for argument \code{tool} of \code{\link[=port4me]{port4me()}}.
(Default: empty)
}

\item{\code{PORT4ME_USER}:}{
Controls the default value for argument \code{user} of \code{\link[=port4me]{port4me()}}.
(Default: \verb{Sys.info()[["user"]])})
}
}
}
\section{Site-wide and built-in settings}{


\describe{
\item{\code{PORT4ME_EXCLUDE_SITE}, \code{PORT4ME_INCLUDE_SITE},
\code{PORT4ME_PREPEND_SITE}:}{
Additional sets of ports to be excluded, included, and prepended.
These are typically set for all users ("site wide") by a
systems administrator or similar.
(Default: empty)
}

\item{\code{PORT4ME_EXCLUDE_UNSAFE}:}{
Additional sets of ports to be excluded that are considered unsafe
to open in a web browser.
Special token \code{"{chrome}"} expands to the value of environment
variable \code{PORT4ME_EXCLUDE_UNSAFE_CHROME}.
Special token \code{"{firefox}"} expands to the value of environment
variable \code{PORT4ME_EXCLUDE_UNSAFE_FIREFOX}.
The default is to exclude the ports that Chrome and Firefox blocks.
(Default: \code{"{chrome},{firefox}"})
}

\item{\code{PORT4ME_EXCLUDE_UNSAFE_CHROME}:}{
The set of ports that the Chrome web browser considers unsafe and
therefore blocks.
(Default: \href{https://chromium.googlesource.com/chromium/src.git/+/refs/heads/master/net/base/port_util.cc}{ports blocked by Chrome})
}

\item{\code{PORT4ME_EXCLUDE_UNSAFE_FIREFOX}:}{
The set of ports that the Firefox web browser considers unsafe and
therefore blocks.
(Default: \href{https://www-archive.mozilla.org/projects/netlib/portbanning#portlist}{ports blocked by Firefox})
}
}
}

\section{Settings for debugging}{


\describe{
\item{\code{PORT4ME_DEBUG}:}{
If \code{true}, extensive debug messages are generated.
(Default: \code{false})
}
}
}

\examples{
Sys.setenv(PORT4ME_EXCLUDE = "4444,5000-5999,8080")
port4me()


}
\seealso{
Environment variables can be configured for \R, by setting them in
your personal \verb{~/.Renviron} file, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{PORT4ME_EXCLUDE=4848,8080
}\if{html}{\out{</div>}}

For more information, see the \link[base]{Startup} help page.
}
