% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_estimate.R
\name{pp_estimate}
\alias{pp_estimate}
\title{Population Down-Scaling}
\usage{
pp_estimate(
  source,
  target,
  sourcepop,
  sourcecode,
  volume = NULL,
  point = FALSE
)
}
\arguments{
\item{source}{object of class \code{sf}}

\item{target}{object of class \code{sf}}

\item{sourcepop}{source zone population field}

\item{sourcecode}{source zone id field}

\item{volume}{source zone number of floors or height field}

\item{point}{logical - whether to use point geometries or not}
}
\value{
an object of class \code{sf} including population values
}
\description{
Population Down-Scaling
}
\examples{
    library(populR)

    data('source')
    data('target')

    # using area
    pp_estimate(source = source, target = target, sourcepop = pop,
        sourcecode = sid)

    # using volume
    pp_estimate(source = source, target = target, sourcepop = pop,
        sourcecode = sid, volume = floors)

    # point geometries and area
    pp_estimate(source = source, target = target, sourcepop = pop,
        sourcecode = sid, point = TRUE)

    # point geometries and volume
    pp_estimate(source = source, target = target, sourcepop = pop,
        sourcecode = sid, volume = floors, point = TRUE)

}
