% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Tort}
\alias{Tort}
\title{Desert tortoise matrix}
\format{
Object of class \code{matrix}
}
\usage{
data(Tort)
}
\description{
Matrix Projection Model for the desert tortoise \emph{Gopherus agassizii} 
with medium fecundity. The matrix is based on a population in the Western 
Mojave desert. Stages are based on age and size 
(carapace length in mm):\cr
Stage 1: Yearling (age 0-1)\cr
Stage 2: Juvenile 1 (<60 mm)\cr
Stage 3: Juvenile 2 (90-99mm)\cr
Stage 4: Immature 1 (100-139mm)\cr
Stage 5: Immature 2 (140-179mm)\cr
Stage 6: Subadult (180-207mm)\cr
Stage 7: Adult 1 (208-239mm)\cr
Stage 8: Adult 2 (>240mm).
}
\examples{
  # read in data and view
  data(Tort)
  Tort

}
\references{
\itemize{
 \item Doak et al. (1994) Ecol. Appl., 4, 446-460.
}
}
\concept{Gopherus agassizzii}
\concept{data}
\concept{desert}
\concept{tortoise}
\keyword{datasets}
