% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{as.data.table.ratetable}
\alias{as.data.table.ratetable}
\title{Coerce a \code{ratetable} object to \code{data.table}}
\usage{
\method{as.data.table}{ratetable}(x, ...)
}
\arguments{
\item{x}{a \code{ratetable}}

\item{...}{other arguments passed on to \code{as.data.table}}
}
\description{
\code{ratatable} objects used in e.g. \pkg{survival} and \pkg{relsurv}
can be conveniently coerced to a long-format \code{data.frame}.
However, the names and levels of variables in the result
may not match names and levels of variables in your data.
}
\examples{
library(relsurv)
data(slopop)
dt <- as.data.table.ratetable(slopop)
dt
}
\author{
Joonas Miettinen
}
\seealso{
\code{\link[survival]{ratetable}},
\code{\link{as.data.frame.ratetable}}
}

