% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolvar_t.R
\name{poolvar_t}
\alias{poolvar_t}
\title{Visualize Ratio of Variance of Each Pooled Measurement to Variance of Each
Unpooled Measurement as Function of Pool Size}
\usage{
poolvar_t(g = 1:10, mu1 = NULL, mu2 = NULL, sigsq = NULL,
  sigsq1 = sigsq, sigsq2 = sigsq, sigsq_p = 0, sigsq_m = 0,
  multiplicative = FALSE, assay_cost = 100, other_costs = 0,
  labels = TRUE, ylim = NULL)
}
\arguments{
\item{g}{Numeric vector of pool sizes to include.}

\item{mu1, mu2}{Numeric value specifying group means. Required if
\code{multiplicative = TRUE}.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq1, sigsq2}{Numeric value specifying the variance of observations
for each group.}

\item{sigsq_p}{Numeric value specifying the variance of processing errors.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{assay_cost}{Numeric value specifying cost of each assay.}

\item{other_costs}{Numeric value specifying other per-subject costs.}

\item{labels}{Logical value.}

\item{ylim}{Numeric vector.}
}
\value{
Plot generated by \code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for determining whether pooling is a good idea, and finding the
optimal pool size if it is.
}
\examples{
# Plot ratio of variances vs. pool size with default settings
poolvar_t(sigsq = 1)

# Add processing error and other per-subject costs
poolvar_t(sigsq = 1, sigsq_p = 0.2, other_costs = 0.1)


}
